// Jasmine Unit Testing Suite
define([
    'backbone',
    'modules/new-appointment-request/resources/direct/preferred-date/clinics-time-slots-collections',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',
], function (Backbone, ClinicsTimeSlotsCollections, TimeSlotsCollection) {
    'use strict';

    describe('Clinics Time Slots Collections', function () {
        var collection;
        var modelData = {
            appointmentLength: '30',
            appointmentTimeSlot: [
                {
                    availability: true,
                    bookingStatus: '2',
                    endDateTime: '12/10/2016 08:30:00',
                    remainingAllowedOverBookings: '2',
                    startDateTime: '12/10/2016 08:00:00',
                },
                {
                    availability: true,
                    bookingStatus: '2',
                    endDateTime: '12/10/2016 09:00:00',
                    remainingAllowedOverBookings: '2',
                    startDateTime: '12/10/2016 08:30:00',
                },
            ],
            clinicId: '123',
            clinicName: 'MOCK CLINIC NAME 123',
            creditCode: '423',
            hasUserAccessToClinic: true,
            maxOverbooksPerDay: '2',
            specialty: '',
            stopCode: '340',
        };

        beforeEach(function () {
            var Model = ClinicsTimeSlotsCollections.prototype.model;
            collection = new ClinicsTimeSlotsCollections([new Model(modelData, {parse: true})]);
        });

        it('parses clinics with time slots', function () {
            expect(collection.at(0).get('appointmentTimeSlot') instanceof TimeSlotsCollection).toBe(true);
        });
    });
});
